<!DOCTYPE html>
<html lang="pt-PT">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sonamarket Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex items-center justify-center">
        <div class="grid grid-cols-2 gap-0 shadow-lg rounded overflow-hidden w-full max-w-4xl">
            <!-- Left Side - Branding -->
            <div style="background: linear-gradient(135deg, #ff6b35 0%, #f7931e 100%);" class="hidden md:flex flex-col justify-between p-12 text-white">
                <div>
                    <h1 class="text-4xl font-bold mb-2">Sonamarket</h1>
                    <p class="text-xl opacity-90">Plataforma de Administração</p>
                </div>
                <div class="space-y-6">
                    <div class="flex items-start gap-4">
                        <i class="fas fa-chart-bar text-2xl mt-1"></i>
                        <div>
                            <h3 class="font-bold mb-1">Dashboard Avançado</h3>
                            <p class="text-sm opacity-80">Visualize todos os dados do seu negócio em tempo real</p>
                        </div>
                    </div>
                    <div class="flex items-start gap-4">
                        <i class="fas fa-box text-2xl mt-1"></i>
                        <div>
                            <h3 class="font-bold mb-1">Gestão de Produtos</h3>
                            <p class="text-sm opacity-80">Controle completo sobre seu inventário</p>
                        </div>
                    </div>
                    <div class="flex items-start gap-4">
                        <i class="fas fa-shopping-cart text-2xl mt-1"></i>
                        <div>
                            <h3 class="font-bold mb-1">Encomendas</h3>
                            <p class="text-sm opacity-80">Gerencie todas as suas vendas e pedidos</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Side - Form -->
            <div class="bg-white p-12 flex flex-col justify-center">
                <h2 class="text-3xl font-bold text-gray-800 mb-2">Bem-vindo</h2>
                <p class="text-gray-600 mb-8">Aceda ao seu painel de administração</p>

                <?php if($errors->any()): ?>
                    <div class="mb-6 p-4 bg-red-100 text-red-700 rounded">
                        <?php echo e($errors->first()); ?>

                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('login')); ?>" method="POST" class="space-y-6">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label class="block text-gray-700 font-semibold mb-2">Email</label>
                        <input type="email" name="email" value="<?php echo e(old('email')); ?>" class="w-full px-4 py-3 border border-gray-300 rounded focus:outline-none focus:border-orange-500" placeholder="seu@email.com" required>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label class="block text-gray-700 font-semibold mb-2">Senha</label>
                        <input type="password" name="password" class="w-full px-4 py-3 border border-gray-300 rounded focus:outline-none focus:border-orange-500" placeholder="••••••••" required>
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="flex items-center justify-between">
                        <label class="flex items-center">
                            <input type="checkbox" name="remember" class="mr-2">
                            <span class="text-gray-600 text-sm">Recordar-me</span>
                        </label>
                        <a href="#" class="text-orange-500 hover:text-orange-600 text-sm font-semibold">Esqueceu a senha?</a>
                    </div>

                    <button type="submit" class="w-full bg-gradient-to-r from-orange-500 to-orange-600 text-white font-bold py-3 rounded hover:from-orange-600 hover:to-orange-700 transition">
                        Entrar
                    </button>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\Users\savo\Sonamarket\backend\resources\views/auth/login.blade.php ENDPATH**/ ?>