<!DOCTYPE html>
<html lang="pt-PT">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sonamarket API - Documentação</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
    </style>
</head>
<body class="min-h-screen">
    <div class="max-w-7xl mx-auto px-4 py-12">
        <!-- Header -->
        <div class="text-center mb-12">
            <h1 class="text-5xl font-bold text-white mb-4">Sona<span class="text-orange-400">market</span> API</h1>
            <p class="text-xl text-gray-100">Documentação da API REST do Sonamarket</p>
        </div>

        <!-- API Stats -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-12">
            <div class="bg-white rounded-lg shadow-lg p-6 text-center">
                <div class="text-3xl font-bold text-blue-600"><?php echo e(count($products)); ?></div>
                <div class="text-gray-600 mt-2">Produtos</div>
            </div>
            <div class="bg-white rounded-lg shadow-lg p-6 text-center">
                <div class="text-3xl font-bold text-purple-600"><?php echo e(count($categories)); ?></div>
                <div class="text-gray-600 mt-2">Categorias</div>
            </div>
            <div class="bg-white rounded-lg shadow-lg p-6 text-center">
                <div class="text-3xl font-bold text-green-600"><?php echo e(count($customers)); ?></div>
                <div class="text-gray-600 mt-2">Clientes</div>
            </div>
            <div class="bg-white rounded-lg shadow-lg p-6 text-center">
                <div class="text-3xl font-bold text-orange-600"><?php echo e(count($orders)); ?></div>
                <div class="text-gray-600 mt-2">Pedidos</div>
            </div>
        </div>

        <!-- Endpoints -->
        <div class="bg-white rounded-lg shadow-2xl p-8 mb-12">
            <h2 class="text-3xl font-bold mb-8 text-gray-800">Endpoints da API</h2>

            <!-- Products -->
            <div class="mb-8 pb-8 border-b">
                <h3 class="text-2xl font-semibold text-blue-600 mb-4">📦 Produtos</h3>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-blue-500 text-white px-2 py-1 rounded">GET</span>
                    <span class="ml-2">/api/v1/products</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-green-500 text-white px-2 py-1 rounded">POST</span>
                    <span class="ml-2">/api/v1/products</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-yellow-500 text-white px-2 py-1 rounded">PATCH</span>
                    <span class="ml-2">/api/v1/products/{id}</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg font-mono text-sm">
                    <span class="bg-red-500 text-white px-2 py-1 rounded">DELETE</span>
                    <span class="ml-2">/api/v1/products/{id}</span>
                </div>
            </div>

            <!-- Categories -->
            <div class="mb-8 pb-8 border-b">
                <h3 class="text-2xl font-semibold text-purple-600 mb-4">🏷️ Categorias</h3>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-blue-500 text-white px-2 py-1 rounded">GET</span>
                    <span class="ml-2">/api/v1/categories</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-green-500 text-white px-2 py-1 rounded">POST</span>
                    <span class="ml-2">/api/v1/categories</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-yellow-500 text-white px-2 py-1 rounded">PATCH</span>
                    <span class="ml-2">/api/v1/categories/{id}</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg font-mono text-sm">
                    <span class="bg-red-500 text-white px-2 py-1 rounded">DELETE</span>
                    <span class="ml-2">/api/v1/categories/{id}</span>
                </div>
            </div>

            <!-- Customers -->
            <div class="mb-8 pb-8 border-b">
                <h3 class="text-2xl font-semibold text-green-600 mb-4">👥 Clientes</h3>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-blue-500 text-white px-2 py-1 rounded">GET</span>
                    <span class="ml-2">/api/v1/customers</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-green-500 text-white px-2 py-1 rounded">POST</span>
                    <span class="ml-2">/api/v1/customers</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-yellow-500 text-white px-2 py-1 rounded">PATCH</span>
                    <span class="ml-2">/api/v1/customers/{id}</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg font-mono text-sm">
                    <span class="bg-red-500 text-white px-2 py-1 rounded">DELETE</span>
                    <span class="ml-2">/api/v1/customers/{id}</span>
                </div>
            </div>

            <!-- Orders -->
            <div class="mb-8">
                <h3 class="text-2xl font-semibold text-orange-600 mb-4">📋 Pedidos</h3>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-blue-500 text-white px-2 py-1 rounded">GET</span>
                    <span class="ml-2">/api/v1/orders</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-green-500 text-white px-2 py-1 rounded">POST</span>
                    <span class="ml-2">/api/v1/orders</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg mb-2 font-mono text-sm">
                    <span class="bg-yellow-500 text-white px-2 py-1 rounded">PATCH</span>
                    <span class="ml-2">/api/v1/orders/{id}</span>
                </div>
                <div class="bg-gray-50 p-4 rounded-lg font-mono text-sm">
                    <span class="bg-red-500 text-white px-2 py-1 rounded">DELETE</span>
                    <span class="ml-2">/api/v1/orders/{id}</span>
                </div>
            </div>
        </div>

        <!-- Data Preview -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-12">
            <!-- Products Preview -->
            <div class="bg-white rounded-lg shadow-lg p-6">
                <h3 class="text-2xl font-bold mb-4 text-blue-600">Produtos Disponíveis</h3>
                <div class="max-h-96 overflow-y-auto">
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-3 pb-3 border-b">
                            <div class="font-semibold text-gray-800"><?php echo e($product->title); ?></div>
                            <div class="text-sm text-gray-600"><?php echo e($product->price); ?> KZ</div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Categories Preview -->
            <div class="bg-white rounded-lg shadow-lg p-6">
                <h3 class="text-2xl font-bold mb-4 text-purple-600">Categorias Disponíveis</h3>
                <div class="flex flex-wrap gap-2">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="bg-purple-100 text-purple-800 px-3 py-1 rounded-full text-sm font-medium">
                            <?php echo e($category->name); ?>

                        </span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Test Endpoints -->
        <div class="bg-white rounded-lg shadow-lg p-8">
            <h2 class="text-3xl font-bold mb-8 text-gray-800">Testar a API</h2>
            <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded mb-6">
                <p class="text-blue-900"><strong>Dica:</strong> Use o endpoint abaixo para testar:</p>
                <code class="bg-white p-2 rounded block mt-2 font-mono text-sm">http://localhost:8000/api/v1/products</code>
            </div>
            <a href="http://localhost:8000/api/v1/products" target="_blank" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg inline-block transition">
                → Ver Produtos em JSON
            </a>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\Users\savo\Sonamarket\backend\resources\views/api-docs.blade.php ENDPATH**/ ?>