

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page_title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
    <!-- Stats Cards -->
    <div class="bg-white p-6 rounded shadow">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Total Produtos</p>
                <p class="text-3xl font-bold text-orange-500"><?php echo e($totalProducts); ?></p>
            </div>
            <i class="fas fa-box text-orange-500 text-4xl opacity-20"></i>
        </div>
    </div>

    <div class="bg-white p-6 rounded shadow">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Total Encomendas</p>
                <p class="text-3xl font-bold text-blue-500"><?php echo e($totalOrders); ?></p>
            </div>
            <i class="fas fa-shopping-cart text-blue-500 text-4xl opacity-20"></i>
        </div>
    </div>

    <div class="bg-white p-6 rounded shadow">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Total Clientes</p>
                <p class="text-3xl font-bold text-green-500"><?php echo e($totalCustomers); ?></p>
            </div>
            <i class="fas fa-users text-green-500 text-4xl opacity-20"></i>
        </div>
    </div>

    <div class="bg-white p-6 rounded shadow">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Total Categorias</p>
                <p class="text-3xl font-bold text-purple-500"><?php echo e($totalCategories); ?></p>
            </div>
            <i class="fas fa-list text-purple-500 text-4xl opacity-20"></i>
        </div>
    </div>
</div>

<!-- Recent Orders -->
<div class="bg-white rounded shadow">
    <div class="px-6 py-4 border-b border-gray-200">
        <h3 class="text-lg font-bold">Encomendas Recentes</h3>
    </div>
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Número</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Cliente</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Total</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Data</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 font-semibold"><?php echo e($order->order_number); ?></td>
                        <td class="px-6 py-4"><?php echo e($order->customer->name ?? 'N/A'); ?></td>
                        <td class="px-6 py-4 font-bold"><?php echo e(number_format($order->total, 2)); ?> KZ</td>
                        <td class="px-6 py-4">
                            <span class="px-3 py-1 rounded text-white text-sm
                                <?php if($order->status === 'completed'): ?> bg-green-500
                                <?php elseif($order->status === 'pending'): ?> bg-yellow-500
                                <?php elseif($order->status === 'cancelled'): ?> bg-red-500
                                <?php else: ?> bg-blue-500 <?php endif; ?>">
                                <?php echo e(ucfirst($order->status)); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4"><?php echo e($order->created_at->format('d/m/Y H:i')); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-4 text-center text-gray-500">Sem encomendas</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\savo\Sonamarket\backend\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>