

<?php $__env->startSection('title', 'Encomendas'); ?>
<?php $__env->startSection('page_title', 'Gestão de Encomendas'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded shadow overflow-x-auto">
    <table class="w-full">
        <thead class="bg-gray-50 border-b">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Número</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Cliente</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Total</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Data</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ações</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200">
            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 font-semibold"><?php echo e($order->order_number); ?></td>
                    <td class="px-6 py-4"><?php echo e($order->customer->name ?? 'N/A'); ?></td>
                    <td class="px-6 py-4 font-bold"><?php echo e(number_format($order->total, 2)); ?> KZ</td>
                    <td class="px-6 py-4">
                        <form action="<?php echo e(route('admin.orders.update', $order)); ?>" method="POST" class="inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <select name="status" onchange="this.form.submit()" class="px-3 py-1 rounded text-white text-sm font-medium cursor-pointer
                                <?php if($order->status === 'pending'): ?> bg-yellow-500
                                <?php elseif($order->status === 'processing'): ?> bg-blue-500
                                <?php elseif($order->status === 'shipped'): ?> bg-purple-500
                                <?php elseif($order->status === 'delivered'): ?> bg-green-500
                                <?php elseif($order->status === 'cancelled'): ?> bg-red-500
                                <?php else: ?> bg-gray-500 <?php endif; ?>">
                                <option value="pending" <?php echo e($order->status === 'pending' ? 'selected' : ''); ?>>Pendente</option>
                                <option value="processing" <?php echo e($order->status === 'processing' ? 'selected' : ''); ?>>Processando</option>
                                <option value="shipped" <?php echo e($order->status === 'shipped' ? 'selected' : ''); ?>>Enviado</option>
                                <option value="delivered" <?php echo e($order->status === 'delivered' ? 'selected' : ''); ?>>Entregue</option>
                                <option value="cancelled" <?php echo e($order->status === 'cancelled' ? 'selected' : ''); ?>>Cancelado</option>
                            </select>
                        </form>
                    </td>
                    <td class="px-6 py-4"><?php echo e($order->created_at->format('d/m/Y H:i')); ?></td>
                    <td class="px-6 py-4">
                        <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="btn-edit">
                            <i class="fas fa-eye"></i> Ver
                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">Sem encomendas</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\savo\Sonamarket\backend\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>