<!DOCTYPE html>
<html lang="pt-PT">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?> - Sonamarket Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { background-color: #f9fafb; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        
        .sidebar { 
            background: linear-gradient(135deg, #ff6b35 0%, #f7931e 100%);
            box-shadow: 4px 0 15px rgba(0,0,0,0.15);
            overflow: hidden !important;
        }

        .sidebar-header {
            padding: 18px 20px;
            border-bottom: 1px solid rgba(255,255,255,0.2);
            background: rgba(0,0,0,0.1);
        }

        .sidebar-header h1 {
            font-size: 20px;
            font-weight: bold;
            color: white;
            margin: 0;
        }

        .sidebar-header p {
            font-size: 11px;
            color: rgba(255,255,255,0.9);
            margin-top: 2px;
            font-weight: 500;
        }

        .nav-menu {
            margin-top: 20px;
            padding: 0 8px;
            space-y: 8px;
            max-height: calc(100vh - 280px);
            overflow: hidden;
        }

        .nav-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px 14px;
            color: rgba(255,255,255,0.9);
            font-size: 13px;
            font-weight: 500;
            border-radius: 8px;
            transition: all 200ms ease;
            background: rgba(255,255,255,0.05);
            border-left: 3px solid transparent;
            cursor: pointer;
            text-decoration: none;
            margin-bottom: 4px;
            display: block;
        }

        .nav-item:hover {
            background: rgba(255,255,255,0.15);
            transform: translateX(4px);
        }

        .nav-item.active {
            background: rgba(255,255,255,0.25);
            color: white;
            border-left-color: white;
            box-shadow: inset 0 0 0 1px rgba(255,255,255,0.2);
        }

        .nav-item i {
            font-size: 16px;
            width: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0.9;
        }

        .nav-item.active i {
            opacity: 1;
            transform: scale(1.1);
        }

        .sidebar-footer {
            padding: 12px 8px;
            border-top: 1px solid rgba(255,255,255,0.2);
            margin-top: auto;
            background: rgba(0,0,0,0.1);
        }

        .btn-logout {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            padding: 10px 14px;
            width: 100%;
            color: white;
            background: rgba(255,255,255,0.1);
            border: none;
            border-radius: 8px;
            font-size: 13px;
            font-weight: 500;
            cursor: pointer;
            transition: all 200ms ease;
        }

        .btn-logout:hover {
            background: rgba(255,255,255,0.15);
            transform: translateX(4px);
        }

        .btn-primary { background-color: #f97316; color: white; padding: 8px 16px; border-radius: 6px; transition: all 200ms; }
        .btn-primary:hover { background-color: #ea580c; }
        .btn-danger { background-color: #ef4444; color: white; padding: 4px 8px; border-radius: 4px; font-size: 12px; }
        .btn-danger:hover { background-color: #dc2626; }
        .btn-edit { background-color: #3b82f6; color: white; padding: 4px 8px; border-radius: 4px; font-size: 12px; }
        .btn-edit:hover { background-color: #2563eb; }
    </style>
    <?php echo $__env->yieldContent('styles'); ?>
</head>
<body>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <div class="sidebar w-64 text-white flex flex-col fixed h-screen z-50">
            <div class="sidebar-header">
                <h1>Sonamarket</h1>
                <p>Dashboard Admin</p>
            </div>
            
            <nav class="flex-1 overflow-y-auto nav-menu">
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="nav-item <?php if(Route::currentRouteName() === 'admin.dashboard'): ?> active <?php endif; ?>">
                    <i class="fas fa-grid-2"></i> <span>Dashboard</span>
                </a>
                
                <div style="padding: 8px 14px; color: rgba(255,255,255,0.5); font-size: 10px; font-weight: 600; text-transform: uppercase; margin-top: 8px; letter-spacing: 0.5px;">Gestão</div>
                
                <a href="<?php echo e(route('admin.products.index')); ?>" class="nav-item <?php if(str_contains(Route::currentRouteName(), 'admin.products')): ?> active <?php endif; ?>">
                    <i class="fas fa-cube"></i> <span>Produtos</span>
                </a>
                <a href="<?php echo e(route('admin.categories.index')); ?>" class="nav-item <?php if(str_contains(Route::currentRouteName(), 'admin.categories')): ?> active <?php endif; ?>">
                    <i class="fas fa-tags"></i> <span>Categorias</span>
                </a>
                <a href="<?php echo e(route('admin.customers.index')); ?>" class="nav-item <?php if(str_contains(Route::currentRouteName(), 'admin.customers')): ?> active <?php endif; ?>">
                    <i class="fas fa-user-group"></i> <span>Clientes</span>
                </a>
                <a href="<?php echo e(route('admin.orders.index')); ?>" class="nav-item <?php if(str_contains(Route::currentRouteName(), 'admin.orders')): ?> active <?php endif; ?>">
                    <i class="fas fa-bag-shopping"></i> <span>Encomendas</span>
                </a>

                <div style="padding: 8px 14px; color: rgba(255,255,255,0.5); font-size: 10px; font-weight: 600; text-transform: uppercase; margin-top: 8px; letter-spacing: 0.5px;">Conteúdo</div>

                <a href="<?php echo e(route('admin.hero.index')); ?>" class="nav-item <?php if(str_contains(Route::currentRouteName(), 'admin.hero')): ?> active <?php endif; ?>">
                    <i class="fas fa-image"></i> <span>Hero Images</span>
                </a>
                <a href="<?php echo e(route('admin.newsletter.index')); ?>" class="nav-item <?php if(str_contains(Route::currentRouteName(), 'admin.newsletter')): ?> active <?php endif; ?>">
                    <i class="fas fa-envelope"></i> <span>Newsletter</span>
                </a>
                <a href="<?php echo e(route('admin.deals.index')); ?>" class="nav-item <?php if(str_contains(Route::currentRouteName(), 'admin.deals')): ?> active <?php endif; ?>">
                    <i class="fas fa-clock"></i> <span>Timer de Ofertas</span>
                </a>

                <div style="padding: 8px 14px; color: rgba(255,255,255,0.5); font-size: 10px; font-weight: 600; text-transform: uppercase; margin-top: 8px; letter-spacing: 0.5px;">Sistema</div>

                <a href="/api-docs" target="_blank" class="nav-item">
                    <i class="fas fa-code"></i> <span>API Docs</span>
                </a>
                <a href="/" target="_blank" class="nav-item">
                    <i class="fas fa-globe"></i> <span>Frontend</span>
                </a>
            </nav>

            <div class="sidebar-footer">
                <form action="<?php echo e(route('logout')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn-logout">
                        <i class="fas fa-sign-out-alt"></i> <span>Sair</span>
                    </button>
                </form>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden ml-64">
            <!-- Header -->
            <header class="bg-white border-b border-gray-200 shadow-sm">
                <div class="px-8 py-4 flex justify-between items-center">
                    <h2 class="text-2xl font-bold text-gray-800"><?php echo $__env->yieldContent('page_title'); ?></h2>
                    <div class="flex items-center gap-4">
                        <span class="text-gray-600"><?php echo e(auth()->user()->email ?? 'Admin'); ?></span>
                        <img src="https://via.placeholder.com/40" alt="Avatar" class="w-10 h-10 rounded-full">
                    </div>
                </div>
            </header>

            <!-- Content Area -->
            <main class="flex-1 overflow-auto">
                <div class="p-8">
                    <?php if($errors->any()): ?>
                        <div class="mb-4 p-4 bg-red-100 text-red-700 rounded">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?php if(session('success')): ?>
                        <div class="mb-4 p-4 bg-green-100 text-green-700 rounded">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </main>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\Users\savo\Sonamarket\backend\resources\views/admin/layout.blade.php ENDPATH**/ ?>