

<?php $__env->startSection('title', 'Clientes'); ?>
<?php $__env->startSection('page_title', 'Gestão de Clientes'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded shadow overflow-x-auto">
    <table class="w-full">
        <thead class="bg-gray-50 border-b">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Nome</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Email</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Telefone</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Cidade</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ativo</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ações</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200">
            <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 font-semibold"><?php echo e($customer->name); ?></td>
                    <td class="px-6 py-4"><?php echo e($customer->email); ?></td>
                    <td class="px-6 py-4"><?php echo e($customer->phone); ?></td>
                    <td class="px-6 py-4"><?php echo e($customer->city); ?></td>
                    <td class="px-6 py-4">
                        <span class="px-2 py-1 rounded text-white text-xs <?php echo e($customer->active ? 'bg-green-500' : 'bg-gray-400'); ?>">
                            <?php echo e($customer->active ? 'Sim' : 'Não'); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4">
                        <button onclick="viewCustomer(<?php echo e($customer->id); ?>)" class="btn-edit">
                            <i class="fas fa-eye"></i> Ver
                        </button>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">Sem clientes</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<script>
function viewCustomer(id) {
    // Implementar visualização de cliente
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\savo\Sonamarket\backend\resources\views/admin/customers/index.blade.php ENDPATH**/ ?>