<?php

use Illuminate\Support\Facades\Route;
use App\Models\Product;
use App\Models\Category;
use App\Models\Customer;
use App\Models\Order;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\HeroController;
use Illuminate\Support\Facades\Auth;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/api-docs', function () {
    return view('api-docs', [
        'products' => Product::all(),
        'categories' => Category::all(),
        'customers' => Customer::all(),
        'orders' => Order::with('items')->get(),
    ]);
});

// Auth Routes
Route::get('login', function () {
    return view('auth.login');
})->name('login')->middleware('guest');

Route::post('login', function (\Illuminate\Http\Request $request) {
    $credentials = $request->validate([
        'email' => 'required|email',
        'password' => 'required',
    ]);

    if (Auth::attempt($credentials, $request->boolean('remember'))) {
        $request->session()->regenerate();
        return redirect()->intended('admin');
    }

    return back()->withErrors([
        'email' => 'As credenciais fornecidas não correspondem aos nossos registos.',
    ]);
})->name('login.post');

Route::post('logout', function (\Illuminate\Http\Request $request) {
    Auth::logout();
    $request->session()->invalidate();
    $request->session()->regenerateToken();
    return redirect('/');
})->name('logout');

// Admin Routes
Route::prefix('admin')->name('admin.')->middleware('auth')->group(function () {
    Route::get('/', [AdminController::class, 'dashboard'])->name('dashboard');
    Route::get('dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    
    // Products
    Route::get('products', [AdminController::class, 'productsIndex'])->name('products.index');
    Route::post('products', [AdminController::class, 'productsStore'])->name('products.store');
    Route::patch('products/{product}', [AdminController::class, 'productsUpdate'])->name('products.update');
    Route::delete('products/{product}', [AdminController::class, 'productsDestroy'])->name('products.destroy');
    
    // Categories
    Route::get('categories', [AdminController::class, 'categoriesIndex'])->name('categories.index');
    Route::post('categories', [AdminController::class, 'categoriesStore'])->name('categories.store');
    Route::delete('categories/{category}', [AdminController::class, 'categoriesDestroy'])->name('categories.destroy');
    
    // Customers
    Route::get('customers', [AdminController::class, 'customersIndex'])->name('customers.index');
    
    // Orders
    Route::get('orders', [AdminController::class, 'ordersIndex'])->name('orders.index');
    Route::get('orders/{order}', [AdminController::class, 'ordersShow'])->name('orders.show');
    Route::patch('orders/{order}', [AdminController::class, 'ordersUpdate'])->name('orders.update');
    
    // Hero Images
    Route::get('hero', [HeroController::class, 'index'])->name('hero.index');
    Route::post('hero', [HeroController::class, 'store'])->name('hero.store');
    Route::patch('hero/{heroImage}', [HeroController::class, 'update'])->name('hero.update');
    
    // Newsletter
    Route::get('newsletter', [AdminController::class, 'newsletterIndex'])->name('newsletter.index');
    Route::delete('newsletter/{subscriber}', [AdminController::class, 'newsletterDestroy'])->name('newsletter.destroy');
    
    // Deal Settings
    Route::get('deals', [AdminController::class, 'dealSettingsIndex'])->name('deals.index');
    Route::post('deals', [AdminController::class, 'dealSettingsUpdate'])->name('deals.update');
    Route::delete('hero/{heroImage}', [HeroController::class, 'destroy'])->name('hero.destroy');
    Route::post('hero/{heroImage}/upload', [HeroController::class, 'uploadImage'])->name('hero.upload');
});
