<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\CustomerController;
use App\Http\Controllers\Api\OrderController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\AddressController;
use App\Http\Controllers\Api\ImageController;
use App\Http\Controllers\Api\FavoriteController;
use App\Http\Controllers\HeroController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\DealSettingController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

// Public API Routes
Route::prefix('v1')->group(function () {
    // Auth Routes (Public)
    Route::post('/auth/register', [AuthController::class, 'register']);
    Route::post('/auth/login', [AuthController::class, 'login']);
    Route::post('/auth/logout', [AuthController::class, 'logout']);
    
    // Categories
    Route::apiResource('categories', CategoryController::class);
    
    // Products
    Route::apiResource('products', ProductController::class);
    
    // Customers
    Route::apiResource('customers', CustomerController::class);
    
    // Orders
    Route::apiResource('orders', OrderController::class);

    // Addresses
    Route::get('/customers/{customerId}/addresses', [AddressController::class, 'index']);
    Route::post('/customers/{customerId}/addresses', [AddressController::class, 'store']);
    Route::get('/customers/{customerId}/addresses/{addressId}', [AddressController::class, 'show']);
    Route::put('/customers/{customerId}/addresses/{addressId}', [AddressController::class, 'update']);
    Route::delete('/customers/{customerId}/addresses/{addressId}', [AddressController::class, 'destroy']);

    // Favorites
    Route::get('/favorites', [FavoriteController::class, 'index']);
    Route::post('/favorites', [FavoriteController::class, 'store']);
    Route::delete('/favorites', [FavoriteController::class, 'destroy']);
    Route::get('/favorites/check', [FavoriteController::class, 'check']);

    // Images
    Route::get('/images/product/{productId}', [ImageController::class, 'productImage']);
    
    // Hero Images
    Route::get('/hero', [HeroController::class, 'index']);

    // Newsletter (Public)
    Route::post('/newsletter/subscribe', [NewsletterController::class, 'subscribe']);
    
    // Admin Newsletter Routes (Protected - requires auth)
    Route::middleware('auth:sanctum')->prefix('admin/newsletter')->group(function () {
        Route::get('/subscribers', [NewsletterController::class, 'index']);
        Route::get('/stats', [NewsletterController::class, 'stats']);
        Route::put('/subscribers/{id}/unsubscribe', [NewsletterController::class, 'unsubscribe']);
        Route::delete('/subscribers/{id}', [NewsletterController::class, 'destroy']);
    });
    
    // Newsletter Export (Public for admin panel direct access)
    Route::get('/newsletter/export', [NewsletterController::class, 'export'])->name('api.newsletter.export');
    
    // Deal Settings (Public read, Protected write)
    Route::get('/deals/timer', [DealSettingController::class, 'getEndTime']);
    Route::post('/admin/deals/timer', [DealSettingController::class, 'updateEndTime'])->middleware('auth:sanctum');
    
    // SMS Test Route
    Route::post('/test/sms', function (Request $request) {
        $smsService = app(\App\Services\SmsService::class);
        $phone = $request->input('phone', '923101032');
        $message = $request->input('message', 'Teste de SMS da SonaMarket');
        
        \Log::info('SMS test endpoint called', ['phone' => $phone, 'message' => $message]);
        
        $result = $smsService->sendSms($phone, $message);
        
        return response()->json([
            'success' => $result,
            'phone' => $phone,
            'message' => $message,
            'note' => 'Check storage/logs/laravel.log for detailed logs'
        ]);
    });
});
