@extends('admin.layout')

@section('title', 'Encomenda #' . $order->order_number)
@section('page_title', 'Encomenda #' . $order->order_number)

@section('content')
<div class="grid grid-cols-3 gap-6 mb-6">
    <div class="bg-white p-6 rounded shadow">
        <p class="text-gray-500 text-sm mb-2">Status</p>
        <form action="{{ route('admin.orders.update', $order) }}" method="POST" class="flex gap-2 items-center">
            @csrf
            @method('PATCH')
            <select name="status" class="flex-1 px-4 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="pending" {{ $order->status === 'pending' ? 'selected' : '' }}>Pendente</option>
                <option value="processing" {{ $order->status === 'processing' ? 'selected' : '' }}>Processando</option>
                <option value="shipped" {{ $order->status === 'shipped' ? 'selected' : '' }}>Enviado</option>
                <option value="delivered" {{ $order->status === 'delivered' ? 'selected' : '' }}>Entregue</option>
                <option value="cancelled" {{ $order->status === 'cancelled' ? 'selected' : '' }}>Cancelado</option>
            </select>
            <button type="submit" class="btn-primary px-4 py-2">Atualizar</button>
        </form>
    </div>
    <div class="bg-white p-6 rounded shadow">
        <p class="text-gray-500 text-sm">Total</p>
        <p class="text-2xl font-bold">{{ number_format($order->total, 2) }} KZ</p>
    </div>
    <div class="bg-white p-6 rounded shadow">
        <p class="text-gray-500 text-sm">Data</p>
        <p class="text-2xl font-bold">{{ $order->created_at->format('d/m/Y') }}</p>
    </div>
</div>

<!-- Customer Info -->
<div class="bg-white rounded shadow p-6 mb-6">
    <h3 class="text-lg font-bold mb-4">Informações do Cliente</h3>
    <div class="grid grid-cols-2 gap-6">
        <div>
            <p class="text-gray-500 text-sm">Nome</p>
            <p class="text-lg font-semibold">{{ $order->customer->name }}</p>
        </div>
        <div>
            <p class="text-gray-500 text-sm">Email</p>
            <p class="text-lg font-semibold">{{ $order->customer->email }}</p>
        </div>
        <div>
            <p class="text-gray-500 text-sm">Telefone</p>
            <p class="text-lg font-semibold">{{ $order->customer->phone }}</p>
        </div>
        <div>
            <p class="text-gray-500 text-sm">Cidade</p>
            <p class="text-lg font-semibold">{{ $order->customer->city }}</p>
        </div>
    </div>
</div>

<!-- Order Items -->
<div class="bg-white rounded shadow overflow-x-auto mb-6">
    <div class="px-6 py-4 border-b border-gray-200">
        <h3 class="text-lg font-bold">Artigos da Encomenda</h3>
    </div>
    <table class="w-full">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Produto</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Quantidade</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Preço Unitário</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Subtotal</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200">
            @foreach($order->items as $item)
                <tr>
                    <td class="px-6 py-4">{{ $item->product->title ?? 'Produto Removido' }}</td>
                    <td class="px-6 py-4">{{ $item->quantity }}</td>
                    <td class="px-6 py-4">{{ number_format($item->unit_price, 2) }} KZ</td>
                    <td class="px-6 py-4 font-bold">{{ number_format($item->subtotal, 2) }} KZ</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<!-- Summary -->
<div class="bg-white rounded shadow p-6">
    <div class="flex justify-end w-full">
        <div class="w-1/3">
            <div class="flex justify-between mb-4">
                <span class="text-gray-600">Subtotal:</span>
                <span class="font-semibold">{{ number_format($order->subtotal, 2) }} KZ</span>
            </div>
            <div class="flex justify-between mb-4">
                <span class="text-gray-600">Imposto:</span>
                <span class="font-semibold">{{ number_format($order->tax, 2) }} KZ</span>
            </div>
            <div class="flex justify-between mb-4">
                <span class="text-gray-600">Envio:</span>
                <span class="font-semibold">{{ number_format($order->shipping, 2) }} KZ</span>
            </div>
            <div class="flex justify-between text-lg border-t border-gray-200 pt-4">
                <span class="font-bold">Total:</span>
                <span class="font-bold text-orange-500">{{ number_format($order->total, 2) }} KZ</span>
            </div>
        </div>
    </div>
</div>

<div class="mt-6">
    <a href="{{ route('admin.orders.index') }}" class="text-blue-500 hover:text-blue-700">
        <i class="fas fa-arrow-left mr-2"></i> Voltar às Encomendas
    </a>
</div>
@endsection
