@extends('admin.layout')

@section('title', 'Encomendas')
@section('page_title', 'Gestão de Encomendas')

@section('content')
<div class="bg-white rounded shadow overflow-x-auto">
    <table class="w-full">
        <thead class="bg-gray-50 border-b">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Número</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Cliente</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Total</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Data</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ações</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200">
            @forelse($orders as $order)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 font-semibold">{{ $order->order_number }}</td>
                    <td class="px-6 py-4">{{ $order->customer->name ?? 'N/A' }}</td>
                    <td class="px-6 py-4 font-bold">{{ number_format($order->total, 2) }} KZ</td>
                    <td class="px-6 py-4">
                        <form action="{{ route('admin.orders.update', $order) }}" method="POST" class="inline-block">
                            @csrf
                            @method('PATCH')
                            <select name="status" onchange="this.form.submit()" class="px-3 py-1 rounded text-white text-sm font-medium cursor-pointer
                                @if($order->status === 'pending') bg-yellow-500
                                @elseif($order->status === 'processing') bg-blue-500
                                @elseif($order->status === 'shipped') bg-purple-500
                                @elseif($order->status === 'delivered') bg-green-500
                                @elseif($order->status === 'cancelled') bg-red-500
                                @else bg-gray-500 @endif">
                                <option value="pending" {{ $order->status === 'pending' ? 'selected' : '' }}>Pendente</option>
                                <option value="processing" {{ $order->status === 'processing' ? 'selected' : '' }}>Processando</option>
                                <option value="shipped" {{ $order->status === 'shipped' ? 'selected' : '' }}>Enviado</option>
                                <option value="delivered" {{ $order->status === 'delivered' ? 'selected' : '' }}>Entregue</option>
                                <option value="cancelled" {{ $order->status === 'cancelled' ? 'selected' : '' }}>Cancelado</option>
                            </select>
                        </form>
                    </td>
                    <td class="px-6 py-4">{{ $order->created_at->format('d/m/Y H:i') }}</td>
                    <td class="px-6 py-4">
                        <a href="{{ route('admin.orders.show', $order) }}" class="btn-edit">
                            <i class="fas fa-eye"></i> Ver
                        </a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">Sem encomendas</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection
