@extends('admin.layout')

@section('title', 'Newsletter')
@section('page_title', 'Gestão de Newsletter')

@section('content')
<!-- Statistics Cards -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
    <div class="bg-white p-6 rounded shadow">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Total Subscritores</p>
                <p class="text-3xl font-bold text-orange-500">{{ $stats['total'] }}</p>
            </div>
            <i class="fas fa-users text-orange-500 text-4xl opacity-20"></i>
        </div>
    </div>

    <div class="bg-white p-6 rounded shadow">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Activos</p>
                <p class="text-3xl font-bold text-green-500">{{ $stats['active'] }}</p>
            </div>
            <i class="fas fa-check-circle text-green-500 text-4xl opacity-20"></i>
        </div>
    </div>

    <div class="bg-white p-6 rounded shadow">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Inactivos</p>
                <p class="text-3xl font-bold text-gray-500">{{ $stats['inactive'] }}</p>
            </div>
            <i class="fas fa-ban text-gray-500 text-4xl opacity-20"></i>
        </div>
    </div>

    <div class="bg-white p-6 rounded shadow">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Hoje</p>
                <p class="text-3xl font-bold text-blue-500">{{ $stats['today'] }}</p>
            </div>
            <i class="fas fa-calendar-day text-blue-500 text-4xl opacity-20"></i>
        </div>
    </div>
</div>

<!-- Subscribers Table -->
<div class="bg-white rounded shadow">
    <div class="p-6 border-b border-gray-200">
        <div class="flex justify-between items-center">
            <h3 class="text-xl font-bold text-gray-800">Lista de Subscritores</h3>
            <a href="{{ route('api.newsletter.export') }}" target="_blank" class="btn-primary">
                <i class="fas fa-download mr-2"></i>Exportar CSV
            </a>
        </div>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Data de Subscrição</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">IP</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Acções</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($subscribers as $subscriber)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <i class="fas fa-envelope text-gray-400 mr-2"></i>
                                <span class="text-sm font-medium text-gray-900">{{ $subscriber->email }}</span>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($subscriber->is_active)
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                    <i class="fas fa-check mr-1"></i> Activo
                                </span>
                            @else
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">
                                    <i class="fas fa-ban mr-1"></i> Inactivo
                                </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <i class="fas fa-calendar mr-1"></i>
                            {{ $subscriber->created_at->format('d/m/Y H:i') }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            {{ $subscriber->ip_address ?? 'N/A' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <form action="{{ route('admin.newsletter.destroy', $subscriber) }}" method="POST" class="inline-block" onsubmit="return confirm('Tem certeza que deseja remover este subscritor?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn-danger">
                                    <i class="fas fa-trash"></i> Remover
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center text-gray-500">
                            <i class="fas fa-inbox text-6xl text-gray-300 mb-4"></i>
                            <p class="text-lg">Nenhum subscritor encontrado</p>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    @if($subscribers->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $subscribers->links() }}
        </div>
    @endif
</div>
@endsection
