@extends('admin.layout')

@section('title', 'Hero Images')
@section('page_title', 'Gerenciar Imagens Hero')

@section('content')
<div class="mb-6 flex justify-between items-center">
    <div></div>
    <button onclick="openModal()" class="btn-primary">
        <i class="fas fa-plus mr-2"></i> Novo Slide
    </button>
</div>

<div class="bg-white rounded shadow overflow-x-auto">
    <table class="w-full">
        <thead class="bg-gray-50 border-b">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ordem</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Preview</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Textos</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ativo</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ações</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200">
            @forelse($heroes as $hero)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 font-semibold">{{ $hero->order }}</td>
                    <td class="px-6 py-4">
                        @if($hero->image)
                            <img src="{{ $hero->image }}" alt="Hero {{ $hero->order }}" class="h-16 w-24 object-cover rounded">
                        @else
                            <span class="text-gray-500 text-sm">Sem imagem</span>
                        @endif
                    </td>
                    <td class="px-6 py-4 text-sm">
                        <div class="text-gray-600">
                            <p><strong>Subtítulo:</strong> {{ $hero->subtitle_key }}</p>
                            <p><strong>Descrição:</strong> {{ $hero->description_key }}</p>
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <span class="px-2 py-1 rounded text-white text-xs {{ $hero->active ? 'bg-green-500' : 'bg-gray-400' }}">
                            {{ $hero->active ? 'Sim' : 'Não' }}
                        </span>
                    </td>
                    <td class="px-6 py-4 flex gap-2">
                        <button onclick="editHero({{ $hero->id }}, {{ json_encode($hero) }})" class="btn-edit">
                            <i class="fas fa-edit"></i> Editar
                        </button>
                        <form action="{{ route('admin.hero.destroy', $hero) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn-danger" onclick="return confirm('Tem a certeza?')">
                                <i class="fas fa-trash"></i> Remover
                            </button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="px-6 py-4 text-center text-gray-500">Sem slides</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

<!-- Modal -->
<div id="heroModal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded shadow-lg p-8 w-full max-w-2xl max-h-[90vh] overflow-y-auto">
        <h2 class="text-2xl font-bold mb-6">Novo Slide Hero</h2>
        <form id="heroForm" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div class="grid grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Ordem</label>
                    <input type="number" name="order" class="w-full px-4 py-2 border rounded" required value="1">
                </div>
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Ativo</label>
                    <input type="checkbox" name="active" value="1" class="mr-2" checked>
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Imagem do Slide</label>
                <div class="mb-4">
                    <input type="file" id="imageFile" name="image" class="w-full px-4 py-2 border rounded" accept="image/*">
                </div>
                <div id="imagePreview" class="mt-4"></div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Chave de Subtítulo</label>
                <input type="text" name="subtitle_key" class="w-full px-4 py-2 border rounded" required value="home.hero.slide1.subtitle">
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Chave de Descrição</label>
                <input type="text" name="description_key" class="w-full px-4 py-2 border rounded" required value="home.hero.slide1.description">
            </div>

            <div class="flex gap-4">
                <button type="submit" class="btn-primary flex-1">Salvar Slide</button>
                <button type="button" onclick="closeModal()" class="flex-1 px-4 py-2 border border-gray-300 rounded hover:bg-gray-50">Cancelar</button>
            </div>
        </form>
    </div>
</div>

<script>
function openModal() {
    document.getElementById('heroModal').classList.remove('hidden');
    document.getElementById('heroForm').action = "{{ route('admin.hero.store') }}";
    document.getElementById('heroForm').method = 'POST';
    document.getElementById('imagePreview').innerHTML = '';
    document.getElementById('heroForm').reset();
    document.querySelector('input[name="order"]').value = 1;
    document.querySelector('input[name="active"]').checked = true;
}

function closeModal() {
    document.getElementById('heroModal').classList.add('hidden');
}

function editHero(id, hero) {
    document.getElementById('heroModal').classList.remove('hidden');
    document.getElementById('heroForm').action = `/admin/hero/${id}`;
    document.getElementById('heroForm').method = 'POST';
    
    // Pré-preencher dados
    document.querySelector('input[name="order"]').value = hero.order;
    document.querySelector('input[name="subtitle_key"]').value = hero.subtitle_key;
    document.querySelector('input[name="description_key"]').value = hero.description_key;
    document.querySelector('input[name="active"]').checked = hero.active;
    
    // Mostrar imagem existente
    const preview = document.getElementById('imagePreview');
    preview.innerHTML = '';
    if (hero.image) {
        const div = document.createElement('div');
        div.className = 'relative';
        div.innerHTML = `
            <img src="${hero.image}" alt="Preview" class="w-full h-32 object-cover rounded">
            <p class="text-xs text-gray-600 mt-1">Imagem atual</p>
        `;
        preview.appendChild(div);
    }
    
    // Adicionar método PATCH
    const form = document.getElementById('heroForm');
    const methodInput = form.querySelector('input[name="_method"]');
    if (methodInput) {
        methodInput.value = 'PATCH';
    } else {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = '_method';
        input.value = 'PATCH';
        form.appendChild(input);
    }
}

document.getElementById('imageFile').addEventListener('change', function(e) {
    if (e.target.files && e.target.files[0]) {
        const reader = new FileReader();
        reader.onload = function(event) {
            const preview = document.getElementById('imagePreview');
            preview.innerHTML = `
                <div class="relative">
                    <img src="${event.target.result}" alt="Preview" class="w-full h-32 object-cover rounded">
                    <p class="text-xs text-gray-600 mt-1">${e.target.files[0].name}</p>
                </div>
            `;
        };
        reader.readAsDataURL(e.target.files[0]);
    }
});

document.getElementById('heroForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch(this.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(async response => {
        if (response.ok) {
            window.location.reload();
        } else {
            try {
                const data = await response.json();
                const errors = data.errors || {};
                const errorMsg = Object.values(errors).flat().join(', ') || 'Erro ao salvar';
                alert('Erro ao salvar: ' + errorMsg);
            } catch (e) {
                const error = await response.text();
                console.error('Erro ao salvar:', error);
                alert('Erro ao salvar: ' + error);
            }
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao salvar: ' + error.message);
    });
});
</script>
@endsection
