@extends('admin.layout')

@section('title', 'Configurar Timer de Ofertas')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-2xl mx-auto">
        <div class="bg-white rounded-lg shadow-md p-6">
            <h1 class="text-2xl font-bold mb-6">Configurar Timer de Ofertas</h1>

            @if(session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    {{ session('error') }}
                </div>
            @endif

            <div class="mb-6">
                <h2 class="text-lg font-semibold mb-2">Status Atual</h2>
                @if($setting)
                    <div class="bg-gray-50 p-4 rounded">
                        <p class="mb-2"><strong>Término:</strong> {{ $setting->end_time->format('d/m/Y H:i:s') }}</p>
                        <p><strong>Tempo Restante:</strong> {{ $remaining_hours }} horas</p>
                    </div>
                @else
                    <div class="bg-gray-50 p-4 rounded">
                        <p class="text-gray-600">Nenhum timer configurado ainda</p>
                    </div>
                @endif
            </div>

            <form action="{{ route('admin.deals.update') }}" method="POST">
                @csrf
                
                <div class="mb-4">
                    <label for="hours" class="block text-sm font-medium text-gray-700 mb-2">
                        Duração da Oferta (em horas)
                    </label>
                    <input 
                        type="number" 
                        id="hours" 
                        name="hours" 
                        min="1" 
                        max="168" 
                        value="24"
                        class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500"
                        required
                    >
                    @error('hours')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                    <p class="text-gray-500 text-sm mt-1">
                        Mínimo: 1 hora | Máximo: 168 horas (7 dias)
                    </p>
                </div>

                <div class="flex gap-4">
                    <button 
                        type="submit" 
                        class="bg-orange-500 hover:bg-orange-600 text-white font-medium py-2 px-6 rounded-md transition-colors"
                    >
                        Atualizar Timer
                    </button>
                    <a 
                        href="{{ route('admin.dashboard') }}" 
                        class="bg-gray-300 hover:bg-gray-400 text-gray-700 font-medium py-2 px-6 rounded-md transition-colors"
                    >
                        Voltar
                    </a>
                </div>
            </form>

            <div class="mt-8 p-4 bg-blue-50 rounded">
                <h3 class="font-semibold mb-2">ℹ️ Informação</h3>
                <ul class="text-sm text-gray-700 space-y-1">
                    <li>• O timer é compartilhado entre "SuperOfertas" e "Oferta do dia"</li>
                    <li>• Ao atualizar, o novo timer começará imediatamente</li>
                    <li>• O timer é sincronizado automaticamente no site</li>
                    <li>• Quando o timer expirar, um novo de 24 horas será criado automaticamente</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection
