@extends('admin.layout')

@section('title', 'Clientes')
@section('page_title', 'Gestão de Clientes')

@section('content')
<div class="bg-white rounded shadow overflow-x-auto">
    <table class="w-full">
        <thead class="bg-gray-50 border-b">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Nome</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Email</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Telefone</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Cidade</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ativo</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ações</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200">
            @forelse($customers as $customer)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 font-semibold">{{ $customer->name }}</td>
                    <td class="px-6 py-4">{{ $customer->email }}</td>
                    <td class="px-6 py-4">{{ $customer->phone }}</td>
                    <td class="px-6 py-4">{{ $customer->city }}</td>
                    <td class="px-6 py-4">
                        <span class="px-2 py-1 rounded text-white text-xs {{ $customer->active ? 'bg-green-500' : 'bg-gray-400' }}">
                            {{ $customer->active ? 'Sim' : 'Não' }}
                        </span>
                    </td>
                    <td class="px-6 py-4">
                        <button onclick="viewCustomer({{ $customer->id }})" class="btn-edit">
                            <i class="fas fa-eye"></i> Ver
                        </button>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">Sem clientes</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

<script>
function viewCustomer(id) {
    // Implementar visualização de cliente
}
</script>
@endsection
