@extends('admin.layout')

@section('title', 'Categorias')
@section('page_title', 'Gestão de Categorias')

@section('content')
<div class="mb-6 flex justify-between items-center">
    <div></div>
    <button onclick="openModal()" class="btn-primary">
        <i class="fas fa-plus mr-2"></i> Nova Categoria
    </button>
</div>

<div class="bg-white rounded shadow overflow-x-auto">
    <table class="w-full">
        <thead class="bg-gray-50 border-b">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Nome</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Slug</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Produtos</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ações</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200">
            @forelse($categories as $category)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 font-semibold">{{ $category->name }}</td>
                    <td class="px-6 py-4">{{ $category->slug }}</td>
                    <td class="px-6 py-4">{{ $category->products_count }}</td>
                    <td class="px-6 py-4 flex gap-2">
                        <button onclick="editCategory({{ $category->id }})" class="btn-edit">
                            <i class="fas fa-edit"></i> Editar
                        </button>
                        <form action="{{ route('admin.categories.destroy', $category) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn-danger" onclick="return confirm('Tem a certeza?')">
                                <i class="fas fa-trash"></i> Remover
                            </button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="px-6 py-4 text-center text-gray-500">Sem categorias</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

<!-- Modal -->
<div id="categoryModal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded shadow-lg p-8 w-full max-w-md">
        <h2 class="text-2xl font-bold mb-6">Nova Categoria</h2>
        <form id="categoryForm" method="POST">
            @csrf
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Nome</label>
                <input type="text" name="name" class="w-full px-4 py-2 border rounded" required>
            </div>
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Descrição</label>
                <textarea name="description" class="w-full px-4 py-2 border rounded" rows="3"></textarea>
            </div>
            <div class="flex gap-4">
                <button type="submit" class="btn-primary flex-1">Salvar</button>
                <button type="button" onclick="closeModal()" class="flex-1 px-4 py-2 border border-gray-300 rounded hover:bg-gray-50">Cancelar</button>
            </div>
        </form>
    </div>
</div>

<script>
function openModal() {
    document.getElementById('categoryModal').classList.remove('hidden');
    document.getElementById('categoryForm').action = "{{ route('admin.categories.store') }}";
}

function closeModal() {
    document.getElementById('categoryModal').classList.add('hidden');
}

function editCategory(id) {
    // Implementar edição
}
</script>
@endsection
