<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\Category;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $modaCategory = Category::where('slug', 'moda')->first();
        $tecCategory = Category::where('slug', 'tecnologia')->first();
        $esporteCategory = Category::where('slug', 'esporte')->first();

        $products = [
            [
                'category_id' => $modaCategory->id,
                'title' => 'Vestido de Verão Bege Elegante com Detalhes em Renda e Costura Premium',
                'slug' => 'vestido-verao-bege-elegante',
                'description' => 'Vestido elegante perfeito para o verão, feito com tecido de alta qualidade e detalhes em renda. Ideal para ocasiões especiais ou uso diário.',
                'price' => 3930.39,
                'original_price' => 5865.58,
                'image' => '/uploads/1764928561_6932ac31ebe14.jpg',
                'stock' => 50,
                'sold' => 1000,
                'rating' => 4.8,
                'reviews' => 120,
                'active' => true,
                'is_daily_deal' => true,
            ],
            [
                'category_id' => $tecCategory->id,
                'title' => 'Capa Protetora Ultra Fina para Notebook 15.6 polegadas Resistente à Água',
                'slug' => 'capa-notebook-ultra-fina-15.6',
                'description' => 'Proteja seu notebook com esta capa protetora resistente à água. Design ultra fino que não adiciona peso extra ao seu dispositivo.',
                'price' => 9794.64,
                'original_price' => 12999.99,
                'image' => '/uploads/1764928561_6932ac31ec699.jpg',
                'stock' => 75,
                'sold' => 500,
                'rating' => 4.7,
                'reviews' => 87,
                'active' => true,
                'is_daily_deal' => true,
                'is_combo' => true,
            ],
            [
                'category_id' => $esporteCategory->id,
                'title' => 'Tênis de Corrida Performance Leve Respirável Amortecimento Extra',
                'slug' => 'tenis-corrida-performance',
                'description' => 'Tênis de corrida de alta performance com tecnologia de amortecimento avançada. Leve, respirável e confortável para treinos longos.',
                'price' => 3218.93,
                'original_price' => 4799.00,
                'image' => '/uploads/1764928595_6932ac5373073.jpg',
                'stock' => 100,
                'sold' => 2000,
                'rating' => 4.9,
                'reviews' => 245,
                'active' => true,
                'is_daily_deal' => true,
            ],
            [
                'category_id' => $tecCategory->id,
                'title' => 'Fones de Ouvido Bluetooth com Cancelamento de Ruído Ativo e Bateria de Longa Duração',
                'slug' => 'fones-bluetooth-cancelamento-ruido',
                'description' => 'Experimente o som como nunca antes. Tecnologia de cancelamento de ruído ativo, bateria de 40 horas e conforto premium para uso prolongado.',
                'price' => 1736.98,
                'original_price' => 3499.99,
                'image' => '/uploads/1764928595_6932ac53732bf.jpg',
                'stock' => 200,
                'sold' => 50000,
                'rating' => 4.6,
                'reviews' => 1240,
                'badge' => 'Escolha',
                'active' => true,
                'is_daily_deal' => false,
            ],
            [
                'category_id' => $tecCategory->id,
                'title' => 'Controle Sem Fio para Jogos Compatível com PC e Consoles Design Ergonômico',
                'slug' => 'controle-joystick-wireless-pc',
                'description' => 'Controle sem fio ergonômico compatível com PC e principais consoles. Design confortável para longas sessões de jogo.',
                'price' => 1673.13,
                'original_price' => 2499.00,
                'image' => '/uploads/1764928629_6932ac75ecf43.jpg',
                'stock' => 150,
                'sold' => 20000,
                'rating' => 4.8,
                'reviews' => 567,
                'active' => true,
                'is_daily_deal' => false,
            ],
            [
                'category_id' => $tecCategory->id,
                'title' => 'Fones TWS Preto Intra-auricular com Estojo de Carregamento Rápido',
                'slug' => 'fones-tws-preto-carregamento-rapido',
                'description' => 'Fones TWS verdadeiramente sem fio com som de alta qualidade. Estojo de carregamento rápido e bateria de longa duração.',
                'price' => 1394.90,
                'original_price' => 2199.99,
                'image' => '/uploads/1764928629_6932ac75ed11c.jpg',
                'stock' => 180,
                'sold' => 30000,
                'rating' => 4.7,
                'reviews' => 892,
                'badge' => 'Escolha',
                'active' => true,
                'is_daily_deal' => true,
                'is_combo' => true,
            ],
        ];

        foreach ($products as $product) {
            Product::create($product);
        }
    }
}
