<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\HeroImage;

class HeroImageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        HeroImage::truncate();
        
        HeroImage::create([
            'order' => 1,
            'image' => '/images/hero.jpg',
            'title_key' => 'home.hero.slide1.title',
            'subtitle_key' => 'home.hero.slide1.subtitle',
            'description_key' => 'home.hero.slide1.description',
            'active' => true,
        ]);

        HeroImage::create([
            'order' => 2,
            'image' => '/images/hero.jpg',
            'title_key' => 'home.hero.slide2.title',
            'subtitle_key' => 'home.hero.slide2.subtitle',
            'description_key' => 'home.hero.slide2.description',
            'active' => true,
        ]);
    }
}
