<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Category;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Tecnologia',
                'slug' => 'tecnologia',
                'description' => 'Eletrônicos, computadores, smartphones e acessórios',
            ],
            [
                'name' => 'Moda',
                'slug' => 'moda',
                'description' => 'Roupas, calçados, bolsas e acessórios de moda',
            ],
            [
                'name' => 'Casa & Jardim',
                'slug' => 'casa-jardim',
                'description' => 'Móveis, decoração, cozinha e artigos para o lar',
            ],
            [
                'name' => 'Esporte',
                'slug' => 'esporte',
                'description' => 'Equipamentos esportivos e artigos para fitness',
            ],
            [
                'name' => 'Beleza',
                'slug' => 'beleza',
                'description' => 'Cosméticos, cuidados pessoais e higiene',
            ],
            [
                'name' => 'Automotivo',
                'slug' => 'automotivo',
                'description' => 'Acessórios e peças para automóveis',
            ],
            [
                'name' => 'Bebês',
                'slug' => 'bebes',
                'description' => 'Produtos para bebês e crianças',
            ],
            [
                'name' => 'Escritório',
                'slug' => 'escritorio',
                'description' => 'Artigos e móveis para escritório',
            ],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }
    }
}
