<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('deal_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->timestamp('end_time');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Insert default deal end time (24 hours from now)
        DB::table('deal_settings')->insert([
            'key' => 'daily_deals_end_time',
            'end_time' => now()->addHours(24),
            'is_active' => true,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('deal_settings');
    }
};
