<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hero_images', function (Blueprint $table) {
            $table->id();
            $table->integer('order')->default(0);
            $table->string('image')->nullable();
            $table->string('title_key')->default('home.hero.slide1.title');
            $table->string('subtitle_key')->default('home.hero.slide1.subtitle');
            $table->string('description_key')->default('home.hero.slide1.description');
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hero_images');
    }
};
