<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class DisableCache
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        // Disable caching for API responses
        $response->headers->set('Cache-Control', 'no-cache, no-store, must-revalidate', true);
        $response->headers->set('Pragma', 'no-cache', true);
        $response->headers->set('Expires', '0', true);

        return $response;
    }
}
