<?php

namespace App\Http\Controllers;

use App\Models\DealSetting;
use Illuminate\Http\Request;

class DealSettingController extends Controller
{
    public function getEndTime()
    {
        $setting = DealSetting::where('key', 'daily_deals_end_time')
            ->where('is_active', true)
            ->first();

        if (!$setting || $setting->end_time->isPast()) {
            // If no setting or expired, create new one for 24 hours
            $setting = DealSetting::updateOrCreate(
                ['key' => 'daily_deals_end_time'],
                [
                    'end_time' => now()->addHours(24),
                    'is_active' => true,
                ]
            );
        }

        return response()->json([
            'end_time' => $setting->end_time->toIso8601String(),
            'remaining_seconds' => max(0, now()->diffInSeconds($setting->end_time, false)),
        ]);
    }

    public function updateEndTime(Request $request)
    {
        $validated = $request->validate([
            'hours' => 'required|integer|min:1|max:168', // Max 1 week
        ]);

        $setting = DealSetting::updateOrCreate(
            ['key' => 'daily_deals_end_time'],
            [
                'end_time' => now()->addHours($validated['hours']),
                'is_active' => true,
            ]
        );

        return response()->json([
            'success' => true,
            'end_time' => $setting->end_time->toIso8601String(),
            'remaining_seconds' => now()->diffInSeconds($setting->end_time, false),
        ]);
    }
}
