<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Response;

class ImageController
{
    public function productImage($productId)
    {
        $colors = [
            1 => '#FF6B6B',
            2 => '#4ECDC4',
            3 => '#45B7D1',
            4 => '#FFA502',
            5 => '#95E1D3',
            6 => '#F38181',
        ];

        $names = [
            1 => 'Produto #1',
            2 => 'Produto #2',
            3 => 'Produto #3',
            4 => 'Produto #4',
            5 => 'Produto #5',
            6 => 'Produto #6',
        ];

        $color = $colors[$productId] ?? '#999999';
        $name = $names[$productId] ?? 'Produto';

        $svg = <<<SVG
        <svg width="300" height="300" xmlns="http://www.w3.org/2000/svg">
            <rect width="300" height="300" fill="{$color}"/>
            <text x="150" y="150" font-size="24" fill="white" text-anchor="middle" dominant-baseline="middle" font-weight="bold">{$name}</text>
        </svg>
        SVG;

        return response($svg)
            ->header('Content-Type', 'image/svg+xml')
            ->header('Cache-Control', 'public, max-age=31536000');
    }
}
