<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CreateDatabase extends Command
{
    protected $signature = 'db:create';
    protected $description = 'Create database if it does not exist';

    public function handle()
    {
        $database = env('DB_DATABASE');
        $charset = 'utf8mb4';
        $collation = 'utf8mb4_general_ci';

        try {
            // Connect to MySQL without selecting a database
            $connection = DB::connection('mysql');
            $connection->statement("CREATE DATABASE IF NOT EXISTS `{$database}` CHARACTER SET {$charset} COLLATE {$collation}");
            $this->info("Database '{$database}' created successfully!");
        } catch (\Exception $e) {
            $this->error("Error creating database: " . $e->getMessage());
            return 1;
        }

        return 0;
    }
}
